<?php 
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class Menu {
        private $db;
        private $id;
        private $nome;
        private $formRicerca;
        
        function __construct($db, $id, $nome="", $formRicerca="") {
            $this->db   = $db;
            $this->id   = $id;
            $this->nome = $nome;
            $this->formRicerca = $formRicerca;
        }

        function crea() {
            $query    = "INSERT INTO geecD_menu VALUES(NULL,'$this->nome','$this->formRicerca')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geecD_menu SET nome='$this->nome', formRicerca='$this->formRicerca' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecD_menu",$this->id);
            $query    = "DELETE FROM geecD_vociMenu WHERE idMenu=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function creaVoceMenu($tipo,$idContenuto,$nome,$link,$icona,$vocePadre) {
            if($idContenuto>0) {
                $impostazioni  = $this->db->leggiSingolaRiga("geecD_impostazioni",1);
                $datiContenuto = $this->db->leggiSingolaRiga("geecD_contenuti",$idContenuto);
                $link          = GeneratoreUrl::creaUrlContenuto($datiContenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
            }
            
            $queryPosizione = "SELECT * FROM geecD_vociMenu WHERE idMenu=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geecD_vociMenu` (`id`, `idMenu`, `idContenuto`, `vocePadre`, `nome`, `icona`, `immagine`, `tipo`, `link`,`posizione`) "
                    . "VALUES (NULL, '$this->id','$idContenuto',$vocePadre, '$nome', '$icona', '', '$tipo','$link','$posizione')";
            $idNuovoElemento = $this->db->eseguiQueryCreazione($query);
            return $this->stampaSingolaVoceMenuDaId($idNuovoElemento);
        }
        
        function modificaVoceMenu($id,$idContenuto,$tipo, $nome, $link, $icona) {

            if($idContenuto>0) {
                $impostazioni  = $this->db->leggiSingolaRiga("geecD_impostazioni",1);
                $datiContenuto = $this->db->leggiSingolaRiga("geecD_contenuti",$idContenuto);
                $link          = GeneratoreUrl::creaUrlContenuto($datiContenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
            }
            
            $query = "UPDATE geecD_vociMenu SET idContenuto='$idContenuto', icona='$icona', nome='$nome', link='$link', tipo='$tipo' WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function spostaVoce($idVoce,$posizione) {
            $datiVoceMenu   = $this->db->leggiSingolaRiga("geecD_vociMenu",$idVoce);
            
            if($datiVoceMenu["tipo"]=="voce sottomenu") {
                $queryPosizione = "SELECT * FROM geecD_vociMenu WHERE idMenu=$this->id AND id != $idVoce AND tipo LIKE 'voce sottomenu' ORDER BY posizione ASC";
            }
            else {
                $queryPosizione = "SELECT * FROM geecD_vociMenu WHERE idMenu=$this->id AND id != $idVoce AND tipo NOT LIKE 'voce sottomenu' ORDER BY posizione ASC";
            }
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecD_vociMenu SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecD_vociMenu SET posizione=$posizione WHERE id = $idVoce ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaVoceMenu($idVoceMenu) {
            $this->db->eseguiQueryCancellazione("geecD_vociMenu",$idVoceMenu);
        }
        
        function stampaVociMenu() {
            $query    = "SELECT * FROM geecD_vociMenu WHERE idMenu=$this->id AND tipo NOT LIKE 'voce sottomenu' ORDER BY posizione ASC";
            $risQuery = $this->db->eseguiQueryLettura($query);
            while($voceMenu = $risQuery->fetch_assoc()) {
                if($voceMenu["tipo"]=="menu a tendina") {
                    $this->stampaVociSottomenu($voceMenu);                
                }
                else {                
                    $this->stampaSingolaVoceMenu($voceMenu);
                }
            }
        }
        
        function stampaSingolaVoceMenu($datiVociMenu) {
            $nomeEscape = filter_var($datiVociMenu["nome"],FILTER_SANITIZE_MAGIC_QUOTES);
            $posizionePrecedente = ($datiVociMenu["posizione"]<=1) ? 1 : $datiVociMenu["posizione"] - 1;
            $posizioneSuccesiva  = $datiVociMenu["posizione"] +1;
            $stringaIcona = ($datiVociMenu["icona"]!="") ? "<i class=\"{$datiVociMenu["icona"]}\"></i>" : "";
            
            echo"<div id=\"voceMenu{$datiVociMenu["id"]}\" class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                    <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                        <p class=\"mb-0\"><em><strong>$stringaIcona {$datiVociMenu["nome"]}</strong></em>  </p>
                        <small><em>{$datiVociMenu["link"]}</em>  </small>
                    </div>
                    <div class=\"azioni d-flex align-items-center justify-content-end\">
                        <form class=\"d-inline-flex mr-sm-1\">
                            <div class=\"input-group input-group-sm d-flex align-items-center\">
                                <small class=\"text-muted mr-2\">Pos.</small>
                                <input type=\"number\" id=\"nuovaPosizioneVoceMenu{$datiVociMenu["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$datiVociMenu["posizione"]}\">
                                <div class=\"input-group-append\">
                                    <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaVoceMenuInput({$datiVociMenu["id"]},0)\">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaVoceMenu({$datiVociMenu["id"]},$posizionePrecedente)\"><i class=\"fas fa-arrow-up\" ></i></button>
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaVoceMenu({$datiVociMenu["id"]},$posizioneSuccesiva)\"><i class=\"fas fa-arrow-down\"></i></button>
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaVoceMenu({$datiVociMenu["id"]},{$datiVociMenu["idContenuto"]},'$nomeEscape','{$datiVociMenu["icona"]}','{$datiVociMenu["link"]}','{$datiVociMenu["tipo"]}')\"><i class=\"fas fa-cog\"></i></button>
                            <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaVoceMenu({$datiVociMenu["id"]},'$nomeEscape','{$datiVociMenu["tipo"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                        </div>
                   </div>
                </div>";
        }
        
        function stampaVociSottomenu($voceMenu) {
            $posizionePrecedente = ($voceMenu["posizione"]<=1) ? 1 : $voceMenu["posizione"] - 1;
            $posizioneSuccesiva  = $voceMenu["posizione"] +1;
            $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i>" : "";
            
            echo"<div class=\"card mb-3\">
                    <div id=\"voceMenu{$voceMenu["id"]}\" class=\"card-header py-1 px-2 bg-light rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <a href=\"#sottomenu{$voceMenu["id"]}\" data-toggle=\"collapse\" class=\"mb-0\"><em><strong>$stringaIcona {$voceMenu["nome"]}</strong></em>  </a>
                            <small class=\"d-block\"><em>{$voceMenu["link"]}</em>  </small>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <form class=\"d-inline-flex mr-sm-1\">
                                <div class=\"input-group input-group-sm d-flex align-items-center\">
                                    <small class=\"text-muted mr-2\">Pos.</small>
                                    <input type=\"number\" id=\"nuovaPosizioneVoceMenu{$voceMenu["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$voceMenu["posizione"]}\">
                                    <div class=\"input-group-append\">
                                        <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaVoceMenuInput({$voceMenu["id"]},0)\">Salva</button>
                                    </div>
                                </div>
                            </form>
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaVoceMenu({$voceMenu["id"]},$posizionePrecedente)\"><i class=\"fas fa-arrow-up\" ></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaVoceMenu({$voceMenu["id"]},$posizioneSuccesiva)\"><i class=\"fas fa-arrow-down\"></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaVoceMenu({$voceMenu["id"]},{$voceMenu["idContenuto"]},'{$voceMenu["nome"]}','{$voceMenu["icona"]}','{$voceMenu["link"]}','{$voceMenu["tipo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaVoceMenu({$voceMenu["id"]},'{$voceMenu["nome"]}','{$voceMenu["tipo"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                    <div class=\"collapse show\" id=\"sottomenu{$voceMenu["id"]}\">"
                    . "<div class=\"card-body pb-1\" >";
                        $queryVociDiMenu = "SELECT * FROM geecD_vociMenu WHERE idMenu={$voceMenu["idMenu"]} AND tipo LIKE 'voce sottomenu' AND vocePadre='{$voceMenu["id"]}' ORDER BY posizione ASC";
                        $risVociSottomenu   = $this->db->eseguiQueryLettura($queryVociDiMenu);
                        while($voceSottoMenu = $risVociSottomenu->fetch_assoc()) {
                            echo"<div id=\"voceMenu{$voceSottoMenu["id"]}\" class=\"mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                                    <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                        <p class=\"mb-0\"><em><strong>{$voceSottoMenu["nome"]}</strong></em>  </p>
                                        <small><em>{$voceSottoMenu["link"]}</em></small>
                                    </div>
                                    <div class=\"azioni d-flex align-items-center justify-content-end\">
                                        <form class=\"d-inline-flex mr-sm-1\">
                                            <div class=\"input-group input-group-sm d-flex align-items-center\">
                                                <small class=\"text-muted mr-2\">Pos.</small>
                                                <input type=\"number\" id=\"nuovaPosizioneVoceMenu{$voceSottoMenu["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$voceSottoMenu["posizione"]}\">
                                                <div class=\"input-group-append\">
                                                    <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaVoceMenuInput({$voceSottoMenu["id"]},0)\">Salva</button>
                                                </div>
                                            </div>
                                        </form>
                                        <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaVoceMenu({$voceSottoMenu["id"]},0)\"><i class=\"fas fa-arrow-up\" ></i></button>
                                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaVoceMenu({$voceSottoMenu["id"]},2)\"><i class=\"fas fa-arrow-down\"></i></button>
                                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaVoceMenu({$voceSottoMenu["id"]},{$voceSottoMenu["idContenuto"]},'{$voceSottoMenu["nome"]}','{$voceSottoMenu["icona"]}','{$voceSottoMenu["link"]}','{$voceSottoMenu["tipo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                            <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaVoceMenu({$voceSottoMenu["id"]},'{$voceSottoMenu["nome"]}','{$voceSottoMenu["tipo"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                                        </div>
                                    </div>
                                </div>";
                        }
                    echo"</div>"
                    . "</div>";
            echo"</div>";
        }
        
        function stampaSingolaVoceMenuDaId($idVoceMenu) {
            $datiVociMenu = $this->db->leggiSingolaRiga("geecD_vociMenu",$idVoceMenu);
            $this->stampaSingolaVoceMenu($datiVociMenu);
        }
        
        // getter & setter
        function getDb() {
            return $this->db;
        }

        function getId() {
            return $this->id;
        }

        function getNome() {
            return $this->nome;
        }

        function getSetFormRicerca() {
            return $this->formRicerca;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setNome($nome) {
            $this->nome = $nome;
        }

        function setFormRicerca($formRicerca) {
            $this->formRicerca = $formRicerca;
        }

    }